------------------------------------------------------------------------------
--                                                                          --
--                           GNATTEST COMPONENTS                            --
--                                                                          --
--                     G N A T T E S T . O P T I O N S                      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                        Copyright (C) 2011, AdaCore                       --
--                                                                          --
-- GNATTEST  is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software  Foundation;  either  version  2, or (at your option) any later --
-- version.  GNATTEST  is  distributed  in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General  Public License distributed with GNAT; see file COPYING. If --
-- not, write to the  Free  Software  Foundation, 51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.,                                      --
--                                                                          --
-- GNATTEST is maintained by AdaCore (http://www.adacore.com).              --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines a set of options for the tool.

with GNAT.OS_Lib;                use GNAT.OS_Lib;

package GNATtest.Options is

   --  Input options:
   Source_Prj : String_Access := new String'("");
   --  Source project file.

   --  Output options:
   type Output_Mode is (Separate_Root, Parallel, Subdir);

   Default_Output_Mode : constant Output_Mode := Subdir;

   Test_Dir_Prefix   : String_Access := new String'("");
   --  Prefix added to the names of source dirs to get test dirs names.

   Test_Dir_Suffix   : String_Access := new String'("_test");
   --  Suffix added to the names of source dirs to get test dirs names.

   Test_Subdir_Name  : String_Access := new String'("tests");
   --  Name of subdirectory to place test files in case of --sudbir option.

   Separate_Root_Dir : String_Access;
   --  The root directory to place the test file hierarchy in case of
   --  --separate-root option.

   Quiet : Boolean := False;
   --  When true, supresses non-critical output.

   Verbose : Boolean := False;
   --  Verbose mode.

   Test_Case : Boolean := True;
   --  Handling of pragma/aspect Test_Case.
   --  Always true, to be removed.

   Glue_Unimplemented : Boolean := True;
   --  to be removed;

   Suppress_Contacts : Boolean := True;
   --  to be removed;

   Harness_Only : Boolean := False;
   --  Indicates than argument files should be treated as tests but not as
   --  tested ones.

   Stubs_Fail : Boolean := True;
   --  Distinguishes the default behavior of stubs.

   Liskov_Suite : Boolean := False;

   Harness_Dir : String_Access := null;

   Additional_Tests_Prj : String_Access := null;

   Gnattest_Generated_Present : Boolean := False;
   --  Indicates if any of the source projects already have
   --  gnattest_generated.ads so that it won't be duplicated.

end GNATtest.Options;
