------------------------------------------------------------------------------
--                                                                          --
--                          AUNITSTUB COMPONENTS                            --
--                                                                          --
--                     A U N I T S T U B . C O M M O N                      --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 2008-2010, AdaCore                     --
--                                                                          --
-- AUNITSTUB is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software  Foundation;  either  version  2, or (at your option) any later --
-- version.  AUNITSTUB  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General  Public License distributed with GNAT; see file COPYING. If --
-- not, write to the  Free  Software  Foundation, 51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.,                                      --
--                                                                          --
-- AUNITSTUB is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Characters.Handling;     use Ada.Characters.Handling;
with Ada.Text_IO;

with Asis.Implementation;         use Asis.Implementation;

with AUnitStub.Options;

package body AUnitStub.Common is

   --------------------------
   --  Report_AUnit_Usage  --
   --------------------------
   procedure Report_AUnit_Usage is
   begin
      Report_Err ("aunistub: trying to process aunit itself!");
      Report_Err ("aunistub: Fatal_Error raised, terminating process.");
   end Report_AUnit_Usage;

   ------------------
   --  Report_Err  --
   ------------------
   procedure Report_Err (Message : String) is
   begin
      Ada.Text_IO.Put_Line (Ada.Text_IO.Standard_Error, Message);
   end Report_Err;

   ------------------
   --  Report_Std  --
   ------------------
   procedure Report_Std (Message : String; Offset : Integer := 0) is
   begin

      if AUnitStub.Options.Quiet then
         return;
      end if;

      for I in 1 .. Offset loop
         Ada.Text_IO.Put (Ada.Text_IO.Standard_Output, " ");
      end loop;

      Ada.Text_IO.Put_Line (Ada.Text_IO.Standard_Output, Message);
   end Report_Std;

   -------------------------------------
   -- Report_Unhandled_ASIS_Exception --
   -------------------------------------
   procedure Report_Unhandled_ASIS_Exception (Ex : Exception_Occurrence) is
   begin
      Report_Err ("ASIS exception (" & Exception_Name (Ex) & ") is raised");
      Report_Err ("ASIS Error Status is " & Status'Img);
      Report_Err ("ASIS Diagnosis is " & To_String (Diagnosis));

      Set_Status;
   end Report_Unhandled_ASIS_Exception;

   --------------------------------
   -- Report_Unhandled_Exception --
   --------------------------------
   procedure Report_Unhandled_Exception (Ex : Exception_Occurrence) is
   begin
      Report_Err (Exception_Information (Ex));
   end Report_Unhandled_Exception;

end AUnitStub.Common;
