------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--                     G N A T C H E C K . O U T P U T                      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                    Copyright (C) 2004-2011, AdaCore                      --
--                                                                          --
-- GNATCHECK  is  free  software;  you can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATCHECK is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines the output routines for gnatcheck

package Gnatcheck.Output is

   procedure Brief_Help;
   --  Prints the brief gnatcheck help info into Stderr

   procedure Set_Coding_Standard_File_Name (Fname : String);
   --  Stores the name of the file to write the sample coding standard in.

   procedure Write_Coding_Standard;
   --  Writes down the coding standard file and closes the corresponding file.

   ------------------------------------------------
   -- Routines for creating the gnatcheck report --
   ------------------------------------------------

   procedure Set_Report_File;
   --  Creates and/or opens the gnatcheck report file. If the file with the
   --  same name as the name of the report file already exists, it is silently
   --  and unconditionally overridden.

   procedure Close_Report_File;
   --  Closes the report file.

   --  The following routines should be called only after the call to
   --  Set_Report_File. They should not be called after the call to
   --  Close_Report_File

   procedure Report
     (Message      : String;
      Indent_Level : Natural := 0);
   --  Sends the Message into the report file. The line is then closed (by
   --  appending the EOL character(s)). If Indent_Level is not zero, Message
   --  is prepended by Indent_Level indentation string (currently the
   --  indentation string consists of three space characters).

   procedure Report_No_EOL
     (Message      : String;
      Indent_Level : Natural := 0);
   --  Similar to the previous routine, but it does not close the output line.

   procedure Report_EOL;
   --  Closes the line  in the output file.

end Gnatcheck.Output;
