------------------------------------------------------------------------------
--                                                                          --
--                          AUNITGLUE COMPONENTS                            --
--                                                                          --
--                    A U N I T G L U E . O P T I O N S                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2008-2011, AdaCore                     --
--                                                                          --
-- AUNITGLUE is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software  Foundation;  either  version  2, or (at your option) any later --
-- version.  AUNITGLUE  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General  Public License distributed with GNAT; see file COPYING. If --
-- not, write to the  Free  Software  Foundation, 51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.,                                      --
--                                                                          --
-- AUNITGLUE is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines a set of options for the tool.

with GNAT.OS_Lib;                use GNAT.OS_Lib;

package AUnitGlue.Options is

   Liskov_Suite : Boolean := False;
   --  Creating special suite to test a cild unit as it's parent

   Quiet : Boolean := False;
   --  When true, supresses non-critical output.

   Output_Dir : String_Access := new String'(".");
   --  Output directory to place generated files.

   Source_Prj : String_Access := new String'("");
   --  Source project file.

   Suppress_Contacts : Boolean := False;

   Glue_Unimplemented : Boolean := False;
   --  Indicates if unimplemented tests should also be included into suites.

end AUnitGlue.Options;
