------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                        G N A T P P . O U T P U T                         --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                    Copyright (C) 2001-2011, AdaCore                      --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write to the Free Software Foundation,  51 Franklin Street, Fifth Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
-- GNATPP is maintained by AdaCore (http://www.adacore.com)                 --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines various output routines

with ASIS_UL.Source_Table; use ASIS_UL.Source_Table;

package GNATPP.Output is

   procedure Set_Output (SF : SF_Id; Success : out Boolean);
   --  Creates or opens, if needed, and sets the output file for SF, depending
   --  on gnatpp options. Success is set ON if the output file has been
   --  successfully opened, and OFF otherwise

   procedure Brief_Help;
   --  Prints the brief help into the error stream.

   procedure XML_Help;
   --  Prints the XML description of the tool's options to be used to create
   --  the gnatpp GUI in GPS.

   function PP_Suffix  return String;
   function NPP_Suffix return String;
   --  These functions return suffixes for the file names for default result
   --  and backup copy files. ('.pp' and '.npp' for all hosts but OpenVMS and
   --  '$PP' and '$NPP' for OpenVMS

   procedure Set_Form_String;
   --  Sets the value used for the Form parameter of Create and Open
   --  procedures, this value defines the encoding used for the output file(s).

   procedure Correct_EOL;
   --  This is a text filter procedure that converts the line end format of the
   --  result file to the format set by GNATPP.Options.Out_File_Format.

   procedure Correct_Trailing_Spaces;
   --  This is a text filter procedure that removes trailng spaces if they
   --  because of some reason appear at the end of the lines of the result
   --  source. This is NOT a proper solution for trailing spaces problem, but
   --  it does not make sense to invest efforts in proper solution for this
   --  simple-minded one-pass scheme.

end GNATPP.Output;
